%------------------------------------------------------------------------------
% File     : ITP169^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Safety_Regular problem prob_273__3352790_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Safety_Regular/prob_273__3352790_1 [Des21]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.15 v8.1.0, 0.18 v7.5.0
% Syntax   : Number of formulae    :  333 ( 134 unt;  48 typ;   0 def)
%            Number of atoms       : 1026 ( 517 equ;   0 cnn)
%            Maximal formula atoms :   17 (   3 avg)
%            Number of connectives : 4010 (  58   ~;  38   |; 438   &;3295   @)
%                                         (   0 <=>; 181  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   7 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :  141 ( 141   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   42 (  41 usr;  13 con; 0-4 aty)
%            Number of variables   :  936 (  10   ^; 770   !; 156   ?; 936   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:37:39.643
%------------------------------------------------------------------------------
% Could-be-implicit typings (7)
thf(ty_n_t__Views__Oview__Oview____ext_It__Product____Type__Ounit_J,type,
    view_e774982825t_unit: $tType ).

thf(ty_n_t__RealInt__Oreal____int,type,
    real_int: $tType ).

thf(ty_n_t__NatInt__Onat____int,type,
    nat_int: $tType ).

thf(ty_n_t__Traffic__Otraffic,type,
    traffic: $tType ).

thf(ty_n_t__Real__Oreal,type,
    real: $tType ).

thf(ty_n_t__Cars__Ocars,type,
    cars: $tType ).

thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

% Explicit typings (41)
thf(sy_c_Groups_Oone__class_Oone_001t__Nat__Onat,type,
    one_one_nat: nat ).

thf(sy_c_Groups_Oplus__class_Oplus_001t__Nat__Onat,type,
    plus_plus_nat: nat > nat > nat ).

thf(sy_c_Groups_Oplus__class_Oplus_001t__Real__Oreal,type,
    plus_plus_real: real > real > real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Nat__Onat,type,
    zero_zero_nat: nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Real__Oreal,type,
    zero_zero_real: real ).

thf(sy_c_Length_Osensors_Olen,type,
    len: ( cars > traffic > cars > real ) > view_e774982825t_unit > traffic > cars > real_int ).

thf(sy_c_Move_Otraffic_Omove,type,
    move: traffic > traffic > view_e774982825t_unit > view_e774982825t_unit ).

thf(sy_c_NatInt_Onat__int_Ocard_H,type,
    nat_card: nat_int > nat ).

thf(sy_c_Orderings_Obot__class_Obot_001t__NatInt__Onat____int,type,
    bot_bot_nat_int: nat_int ).

thf(sy_c_Orderings_Oord__class_Oless_001t__NatInt__Onat____int,type,
    ord_less_nat_int: nat_int > nat_int > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Nat__Onat,type,
    ord_less_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Real__Oreal,type,
    ord_less_real: real > real > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__NatInt__Onat____int,type,
    ord_less_eq_nat_int: nat_int > nat_int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Nat__Onat,type,
    ord_less_eq_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__RealInt__Oreal____int,type,
    ord_less_eq_real_int: real_int > real_int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Real__Oreal,type,
    ord_less_eq_real: real > real > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Views__Oview__Oview____ext_It__Product____Type__Ounit_J,type,
    ord_le461438217t_unit: view_e774982825t_unit > view_e774982825t_unit > $o ).

thf(sy_c_RealInt_Oreal__int_Olength,type,
    real_length: real_int > real ).

thf(sy_c_Regular__Sensors_Oregular,type,
    regular_regular: cars > traffic > cars > real ).

thf(sy_c_Restriction_Orestriction_Orestrict,type,
    restrict: view_e774982825t_unit > ( cars > nat_int ) > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Oabstract,type,
    abstract: traffic > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Oclm,type,
    clm: traffic > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Ocreate__claim,type,
    create_claim: traffic > cars > nat > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Ocreate__reservation,type,
    create_reservation: traffic > cars > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Ores,type,
    res: traffic > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Owithdraw__claim,type,
    withdraw_claim: traffic > cars > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Owithdraw__reservation,type,
    withdraw_reservation: traffic > cars > nat > traffic > $o ).

thf(sy_c_Views_Oview_Oext_001t__Product____Type__Ounit,type,
    ext_Product_unit: view_e774982825t_unit > real_int ).

thf(sy_c_Views_Oview_Ohchop,type,
    hchop: view_e774982825t_unit > view_e774982825t_unit > view_e774982825t_unit > $o ).

thf(sy_c_Views_Oview_Olan_001t__Product____Type__Ounit,type,
    lan_Product_unit: view_e774982825t_unit > nat_int ).

thf(sy_c_Views_Oview_Oown_001t__Product____Type__Ounit,type,
    own_Product_unit: view_e774982825t_unit > cars ).

thf(sy_c_Views_Oview_Ovchop,type,
    vchop: view_e774982825t_unit > view_e774982825t_unit > view_e774982825t_unit > $o ).

thf(sy_v_c____,type,
    c: cars ).

thf(sy_v_d____,type,
    d: cars ).

thf(sy_v_e____,type,
    e: cars ).

thf(sy_v_thesis____,type,
    thesis: $o ).

thf(sy_v_ts_H_H____,type,
    ts: traffic ).

thf(sy_v_ts_H____,type,
    ts2: traffic ).

thf(sy_v_ts_Ha____,type,
    ts_a: traffic ).

thf(sy_v_ts____,type,
    ts3: traffic ).

thf(sy_v_v____,type,
    v: view_e774982825t_unit ).

% Relevant facts (283)
thf(fact_0_neg,axiom,
    c != e ).

% neg
thf(fact_1_local_Ohmlsl_Osensors__ge,axiom,
    ! [E: cars,Ts: traffic,C: cars] : ( ord_less_real @ zero_zero_real @ ( regular_regular @ E @ Ts @ C ) ) ).

% local.hmlsl.sensors_ge
thf(fact_2_local_Ohmlsl_Olength__geq__zero,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( real_length @ ( ext_Product_unit @ V ) )
        = zero_zero_real )
      | ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ).

% local.hmlsl.length_geq_zero
thf(fact_3_hmlsl_Olen__empty__subview,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars,V3: view_e774982825t_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = zero_zero_real )
        & ( ord_le461438217t_unit @ V3 @ V2 ) )
     => ( ( real_length @ ( len @ regular_regular @ V3 @ Ts @ C ) )
        = zero_zero_real ) ) ).

% hmlsl.len_empty_subview
thf(fact_4__092_060open_062_092_060exists_062v_H_092_060le_062move_Ats_Ats_H_H_Av_O_A_I0_A_060_A_092_060parallel_062ext_Av_H_092_060parallel_062_A_092_060and_062_Alen_Av_H_Ats_H_H_Ac_A_061_Aext_Av_H_A_092_060and_062_Arestrict_Av_H_A_Ires_Ats_H_H_J_Ac_A_061_Alan_Av_H_A_092_060and_062_A_124lan_Av_H_124_A_061_A1_J_A_092_060and_062_A0_A_060_A_092_060parallel_062ext_Av_H_092_060parallel_062_A_092_060and_062_Alen_Av_H_Ats_H_H_Ae_A_061_Aext_Av_H_A_092_060and_062_Arestrict_Av_H_A_Ires_Ats_H_H_J_Ae_A_061_Alan_Av_H_A_092_060and_062_A_124lan_Av_H_124_A_061_A1_092_060close_062,axiom,
    ? [V4: view_e774982825t_unit] :
      ( ( ord_le461438217t_unit @ V4 @ ( move @ ts3 @ ts @ v ) )
      & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V4 ) ) )
      & ( ( len @ regular_regular @ V4 @ ts @ c )
        = ( ext_Product_unit @ V4 ) )
      & ( ( restrict @ V4 @ ( res @ ts ) @ c )
        = ( lan_Product_unit @ V4 ) )
      & ( ( nat_card @ ( lan_Product_unit @ V4 ) )
        = one_one_nat )
      & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V4 ) ) )
      & ( ( len @ regular_regular @ V4 @ ts @ e )
        = ( ext_Product_unit @ V4 ) )
      & ( ( restrict @ V4 @ ( res @ ts ) @ e )
        = ( lan_Product_unit @ V4 ) )
      & ( ( nat_card @ ( lan_Product_unit @ V4 ) )
        = one_one_nat ) ) ).

% \<open>\<exists>v'\<le>move ts ts'' v. (0 < \<parallel>ext v'\<parallel> \<and> len v' ts'' c = ext v' \<and> restrict v' (res ts'') c = lan v' \<and> |lan v'| = 1) \<and> 0 < \<parallel>ext v'\<parallel> \<and> len v' ts'' e = ext v' \<and> restrict v' (res ts'') e = lan v' \<and> |lan v'| = 1\<close>
thf(fact_5_local_Ohmlsl_Ores__ge__zero,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ).

% local.hmlsl.res_ge_zero
thf(fact_6_local_Ohmlsl_Owidth__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ( ( nat_card @ ( lan_Product_unit @ V ) )
        = one_one_nat ) ) ).

% local.hmlsl.width_res
thf(fact_7_abs,axiom,
    abstract @ ts3 @ ts2 ).

% abs
thf(fact_8__092_060open_062move_Ats_Ats_H_Av_A_061_Amove_Ats_H_Ats_H_H_A_Imove_Ats_Ats_H_Av_J_092_060close_062,axiom,
    ( ( move @ ts3 @ ts_a @ v )
    = ( move @ ts_a @ ts @ ( move @ ts3 @ ts_a @ v ) ) ) ).

% \<open>move ts ts' v = move ts' ts'' (move ts ts' v)\<close>
thf(fact_9_move__stab,axiom,
    ( ( move @ ts3 @ ts_a @ v )
    = ( move @ ts3 @ ts @ v ) ) ).

% move_stab
thf(fact_10_local_Ohmlsl_Ores__compose,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) ) ) ).

% local.hmlsl.res_compose
thf(fact_11_local_Ohmlsl_Ores__decompose,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va2 ) ) )
          & ( ( len @ regular_regular @ Va2 @ Ts2 @ C )
            = ( ext_Product_unit @ Va2 ) )
          & ( ( restrict @ Va2 @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va2 ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U2 ) ) )
          & ( ( len @ regular_regular @ U2 @ Ts2 @ C )
            = ( ext_Product_unit @ U2 ) )
          & ( ( restrict @ U2 @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ U2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ U2 ) )
            = one_one_nat ) ) ) ).

% local.hmlsl.res_decompose
thf(fact_12_local_Ohmlsl_Ores__dense,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ W ) ) )
            & ( ( len @ regular_regular @ W @ Ts2 @ C )
              = ( ext_Product_unit @ W ) )
            & ( ( restrict @ W @ ( res @ Ts2 ) @ C )
              = ( lan_Product_unit @ W ) )
            & ( ( nat_card @ ( lan_Product_unit @ W ) )
              = one_one_nat )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U3 ) ) )
            & ( ( len @ regular_regular @ U3 @ Ts2 @ C )
              = ( ext_Product_unit @ U3 ) )
            & ( ( restrict @ U3 @ ( res @ Ts2 ) @ C )
              = ( lan_Product_unit @ U3 ) )
            & ( ( nat_card @ ( lan_Product_unit @ U3 ) )
              = one_one_nat ) ) ) ) ).

% local.hmlsl.res_dense
thf(fact_13_local_Ohmlsl_Ocar__one__lane__non__empty,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [X: cars] :
          ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) )
          | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) ) )
     => ( ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ) ).

% local.hmlsl.car_one_lane_non_empty
thf(fact_14_local_Ohmlsl_Oempty__no__car,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( real_length @ ( ext_Product_unit @ V ) )
        = zero_zero_real )
     => ~ ? [X: cars] :
            ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) )
            | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) ) ) ) ).

% local.hmlsl.empty_no_car
thf(fact_15_local_Ohmlsl_Otwo__lanes__no__car,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( nat_card @ ( lan_Product_unit @ V ) )
       != one_one_nat )
     => ~ ? [X: cars] :
            ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) )
            | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) ) ) ) ).

% local.hmlsl.two_lanes_no_car
thf(fact_16_local_Ohmlsl_Ores__at__most__two,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ~ ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ? [Vb: view_e774982825t_unit,Ua: view_e774982825t_unit] :
              ( ( vchop @ U @ Vb @ Ua )
              & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Vb ) ) )
              & ( ( len @ regular_regular @ Vb @ Ts2 @ C )
                = ( ext_Product_unit @ Vb ) )
              & ( ( restrict @ Vb @ ( res @ Ts2 ) @ C )
                = ( lan_Product_unit @ Vb ) )
              & ( ( nat_card @ ( lan_Product_unit @ Vb ) )
                = one_one_nat )
              & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext_Product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( res @ Ts2 ) @ C )
                = ( lan_Product_unit @ Ua ) )
              & ( ( nat_card @ ( lan_Product_unit @ Ua ) )
                = one_one_nat ) ) ) ).

% local.hmlsl.res_at_most_two
thf(fact_17_local_Ohmlsl_Otwo__res__not__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) )
     => ~ ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) ) ) ).

% local.hmlsl.two_res_not_res
thf(fact_18_local_Ohmlsl_Oclm__ge__zero,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ).

% local.hmlsl.clm_ge_zero
thf(fact_19_local_Ohmlsl_Ohchop__weaken2,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.hchop_weaken2
thf(fact_20_local_Ohmlsl_Ohchop__weaken1,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_e774982825t_unit] :
          ( ? [X_1: view_e774982825t_unit] : ( hchop @ V @ Va2 @ X_1 )
          & ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.hchop_weaken1
thf(fact_21_local_Ohmlsl_Ohchop__weaken,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ? [Vb2: view_e774982825t_unit] :
              ( ? [X_1: view_e774982825t_unit] : ( hchop @ U2 @ Vb2 @ X_1 )
              & ( Phi @ Ts2 @ Vb2 ) ) ) ) ).

% local.hmlsl.hchop_weaken
thf(fact_22_local_Ohmlsl_Ohchop__neg2,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ~ ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
            ( ( hchop @ V @ Va2 @ U2 )
            & ( Phi @ Ts2 @ U2 ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ~ ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.hchop_neg2
thf(fact_23_local_Ohmlsl_Ohchop__neg1,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ~ ? [Va2: view_e774982825t_unit] :
            ( ? [X_1: view_e774982825t_unit] : ( hchop @ V @ Va2 @ X_1 )
            & ( Phi @ Ts2 @ Va2 ) )
     => ? [Va2: view_e774982825t_unit] :
          ( ? [X_1: view_e774982825t_unit] : ( hchop @ V @ Va2 @ X_1 )
          & ~ ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.hchop_neg1
thf(fact_24_local_Ohmlsl_Ohchop__disj__distr2,axiom,
    ! [Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ( Psi @ Ts2 @ W )
              | ( Chi @ Ts2 @ W ) )
            & ( Phi @ Ts2 @ U3 ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Psi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) )
        | ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Chi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_disj_distr2
thf(fact_25_local_Ohmlsl_Ohchop__disj__distr1,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( ( Psi @ Ts2 @ U3 )
              | ( Chi @ Ts2 @ U3 ) ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Psi @ Ts2 @ U3 ) )
        | ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_disj_distr1
thf(fact_26_local_Ohmlsl_Ohchop__assoc,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ? [X2: view_e774982825t_unit,Y: view_e774982825t_unit] :
                ( ( hchop @ U3 @ X2 @ Y )
                & ( Psi @ Ts2 @ X2 )
                & ( Chi @ Ts2 @ Y ) ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ? [X2: view_e774982825t_unit,Y: view_e774982825t_unit] :
                ( ( hchop @ W @ X2 @ Y )
                & ( Phi @ Ts2 @ X2 )
                & ( Psi @ Ts2 @ Y ) )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_assoc
thf(fact_27_local_Ohmlsl_Ovchop__disj__distr2,axiom,
    ! [Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( ( Psi @ Ts2 @ W )
              | ( Chi @ Ts2 @ W ) )
            & ( Phi @ Ts2 @ U3 ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Psi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) )
        | ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Chi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.vchop_disj_distr2
thf(fact_28_local_Ohmlsl_Ovchop__disj__distr1,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( ( Psi @ Ts2 @ U3 )
              | ( Chi @ Ts2 @ U3 ) ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Psi @ Ts2 @ U3 ) )
        | ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.vchop_disj_distr1
thf(fact_29_local_Ohmlsl_Ov__chop__weaken2,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( vchop @ V @ Va2 @ U2 )
          & ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.v_chop_weaken2
thf(fact_30_local_Ohmlsl_Ov__chop__weaken1,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_e774982825t_unit] :
          ( ? [X_1: view_e774982825t_unit] : ( vchop @ V @ Va2 @ X_1 )
          & ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.v_chop_weaken1
thf(fact_31_local_Ohmlsl_Ov__chop__assoc,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Psi: traffic > view_e774982825t_unit > $o,Chi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ? [X2: view_e774982825t_unit,Y: view_e774982825t_unit] :
                ( ( vchop @ U3 @ X2 @ Y )
                & ( Psi @ Ts2 @ X2 )
                & ( Chi @ Ts2 @ Y ) ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ? [X2: view_e774982825t_unit,Y: view_e774982825t_unit] :
                ( ( vchop @ W @ X2 @ Y )
                & ( Phi @ Ts2 @ X2 )
                & ( Psi @ Ts2 @ Y ) )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.v_chop_assoc
thf(fact_32_local_Ohmlsl_Oglobally__refl,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ! [Ts3: traffic] :
          ( ( abstract @ Ts2 @ Ts3 )
         => ( Phi @ Ts3 @ ( move @ Ts2 @ Ts3 @ V ) ) )
     => ( Phi @ Ts2 @ V ) ) ).

% local.hmlsl.globally_refl
thf(fact_33_local_Ohmlsl_Oglobally__4,axiom,
    ! [Phi: traffic > view_e774982825t_unit > $o,Ts2: traffic,V: view_e774982825t_unit] :
      ( ! [Ts3: traffic] :
          ( ( abstract @ Ts2 @ Ts3 )
         => ( Phi @ Ts3 @ ( move @ Ts2 @ Ts3 @ V ) ) )
     => ! [Ts4: traffic] :
          ( ( abstract @ Ts2 @ Ts4 )
         => ! [Ts_a: traffic] :
              ( ( abstract @ Ts4 @ Ts_a )
             => ( Phi @ Ts_a @ ( move @ Ts4 @ Ts_a @ ( move @ Ts2 @ Ts4 @ V ) ) ) ) ) ) ).

% local.hmlsl.globally_4
thf(fact_34_wd__clm_Ohyps_I1_J,axiom,
    abstract @ ts3 @ ts_a ).

% wd_clm.hyps(1)
thf(fact_35_local_Ohmlsl_Owidth__hchop__stable,axiom,
    ! [X3: nat,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( nat_card @ ( lan_Product_unit @ V ) )
        = X3 )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ( nat_card @ ( lan_Product_unit @ W ) )
              = X3 )
            & ( ( nat_card @ ( lan_Product_unit @ U3 ) )
              = X3 ) ) ) ) ).

% local.hmlsl.width_hchop_stable
thf(fact_36_local_Ohmlsl_Olength__vchop__stable,axiom,
    ! [X3: real,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( real_length @ ( ext_Product_unit @ V ) )
        = X3 )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( ( real_length @ ( ext_Product_unit @ W ) )
              = X3 )
            & ( ( real_length @ ( ext_Product_unit @ U3 ) )
              = X3 ) ) ) ) ).

% local.hmlsl.length_vchop_stable
thf(fact_37_hmlsl_Olen__stable__up,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V22 @ Ts @ C ) ) ) ).

% hmlsl.len_stable_up
thf(fact_38_hmlsl_Olen__stable__down,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V1 @ Ts @ C ) ) ) ).

% hmlsl.len_stable_down
thf(fact_39_hmlsl_Olen__stable,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V1 @ Ts @ C )
        = ( len @ regular_regular @ V22 @ Ts @ C ) ) ) ).

% hmlsl.len_stable
thf(fact_40_hmlsl_Olen__view__hchop__right,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars,V1: view_e774982825t_unit,V22: view_e774982825t_unit] :
      ( ( ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( len @ regular_regular @ V22 @ Ts @ C )
        = ( ext_Product_unit @ V22 ) ) ) ).

% hmlsl.len_view_hchop_right
thf(fact_41_hmlsl_Olen__view__hchop__left,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars,V1: view_e774982825t_unit,V22: view_e774982825t_unit] :
      ( ( ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( len @ regular_regular @ V1 @ Ts @ C )
        = ( ext_Product_unit @ V1 ) ) ) ).

% hmlsl.len_view_hchop_left
thf(fact_42_hmlsl_Olen__compose__hchop,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( ( len @ regular_regular @ V1 @ Ts @ C )
          = ( ext_Product_unit @ V1 ) )
        & ( ( len @ regular_regular @ V22 @ Ts @ C )
          = ( ext_Product_unit @ V22 ) ) )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( ext_Product_unit @ V2 ) ) ) ).

% hmlsl.len_compose_hchop
thf(fact_43_wd__clm_Ohyps_I2_J,axiom,
    ? [C2: cars] : ( withdraw_claim @ ts_a @ C2 @ ts ) ).

% wd_clm.hyps(2)
thf(fact_44_local_Ohmlsl_Olength__split,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va2 ) ) )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U2 ) ) ) ) ) ).

% local.hmlsl.length_split
thf(fact_45_local_Ohmlsl_Olength__meld,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) ) )
     => ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ).

% local.hmlsl.length_meld
thf(fact_46_local_Ohmlsl_Olength__dense,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ W ) ) )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U3 ) ) ) ) ) ) ).

% local.hmlsl.length_dense
thf(fact_47_hmlsl_Olen__empty__on__subview2,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars,V1: view_e774982825t_unit,V22: view_e774982825t_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = zero_zero_real )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( real_length @ ( len @ regular_regular @ V22 @ Ts @ C ) )
        = zero_zero_real ) ) ).

% hmlsl.len_empty_on_subview2
thf(fact_48_hmlsl_Olen__empty__on__subview1,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars,V1: view_e774982825t_unit,V22: view_e774982825t_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = zero_zero_real )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( real_length @ ( len @ regular_regular @ V1 @ Ts @ C ) )
        = zero_zero_real ) ) ).

% hmlsl.len_empty_on_subview1
thf(fact_49_hmlsl_Olen__fills__subview,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) )
     => ? [V12: view_e774982825t_unit,V23: view_e774982825t_unit,V32: view_e774982825t_unit,V4: view_e774982825t_unit] :
          ( ( hchop @ V2 @ V12 @ V23 )
          & ( hchop @ V23 @ V4 @ V32 )
          & ( ( len @ regular_regular @ V4 @ Ts @ C )
            = ( ext_Product_unit @ V4 ) )
          & ( ( real_length @ ( len @ regular_regular @ V4 @ Ts @ C ) )
            = ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) ) ) ) ).

% hmlsl.len_fills_subview
thf(fact_50_d__def,axiom,
    withdraw_claim @ ts_a @ d @ ts ).

% d_def
thf(fact_51_local_Ohmlsl_Owidth__clm,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ( ( nat_card @ ( lan_Product_unit @ V ) )
        = one_one_nat ) ) ).

% local.hmlsl.width_clm
thf(fact_52_local_Ohmlsl_Oclm__dense,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ W ) ) )
            & ( ( len @ regular_regular @ W @ Ts2 @ C )
              = ( ext_Product_unit @ W ) )
            & ( ( restrict @ W @ ( clm @ Ts2 ) @ C )
              = ( lan_Product_unit @ W ) )
            & ( ( nat_card @ ( lan_Product_unit @ W ) )
              = one_one_nat )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U3 ) ) )
            & ( ( len @ regular_regular @ U3 @ Ts2 @ C )
              = ( ext_Product_unit @ U3 ) )
            & ( ( restrict @ U3 @ ( clm @ Ts2 ) @ C )
              = ( lan_Product_unit @ U3 ) )
            & ( ( nat_card @ ( lan_Product_unit @ U3 ) )
              = one_one_nat ) ) ) ) ).

% local.hmlsl.clm_dense
thf(fact_53_local_Ohmlsl_Oclm__decompose,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va2 ) ) )
          & ( ( len @ regular_regular @ Va2 @ Ts2 @ C )
            = ( ext_Product_unit @ Va2 ) )
          & ( ( restrict @ Va2 @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va2 ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U2 ) ) )
          & ( ( len @ regular_regular @ U2 @ Ts2 @ C )
            = ( ext_Product_unit @ U2 ) )
          & ( ( restrict @ U2 @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ U2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ U2 ) )
            = one_one_nat ) ) ) ).

% local.hmlsl.clm_decompose
thf(fact_54_local_Ohmlsl_Oclm__compose,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) ) ) ).

% local.hmlsl.clm_compose
thf(fact_55_local_Ohmlsl_Oclm__sing__not__interrupted,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ~ ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ? [Vb: view_e774982825t_unit,Ua: view_e774982825t_unit] :
              ( ( vchop @ U @ Vb @ Ua )
              & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext_Product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( clm @ Ts2 ) @ C )
                = ( lan_Product_unit @ Ua ) )
              & ( ( nat_card @ ( lan_Product_unit @ Ua ) )
                = one_one_nat ) ) ) ).

% local.hmlsl.clm_sing_not_interrupted
thf(fact_56_local_Ohmlsl_Oclm__sing,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ~ ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) ) ).

% local.hmlsl.clm_sing
thf(fact_57_local_Ohmlsl_Ono__clm__before__res2,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ~ ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ? [Vb: view_e774982825t_unit,Ua: view_e774982825t_unit] :
              ( ( hchop @ U @ Vb @ Ua )
              & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext_Product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( res @ Ts2 ) @ C )
                = ( lan_Product_unit @ Ua ) )
              & ( ( nat_card @ ( lan_Product_unit @ Ua ) )
                = one_one_nat ) ) ) ).

% local.hmlsl.no_clm_before_res2
thf(fact_58_local_Ohmlsl_Ono__clm__before__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ~ ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) ) ).

% local.hmlsl.no_clm_before_res
thf(fact_59_local_Ohmlsl_Otwo__res__no__car,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext_Product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ Va ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext_Product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ U ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat ) )
     => ~ ? [X: cars] :
            ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) )
            | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) ) ) ) ).

% local.hmlsl.two_res_no_car
thf(fact_60__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062d_O_Ats_H_A_092_060_094bold_062_092_060midarrow_062wdc_I_Ad_A_J_A_092_060_094bold_062_092_060rightarrow_062_Ats_H_H_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [D: cars] :
        ~ ( withdraw_claim @ ts_a @ D @ ts ) ).

% \<open>\<And>thesis. (\<And>d. ts' \<^bold>\<midarrow>wdc( d ) \<^bold>\<rightarrow> ts'' \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_61_local_Ohmlsl_Ofree__dense,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C3: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C3 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C3 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C3 )
                = bot_bot_nat_int ) ) ) )
      = ( ? [W: view_e774982825t_unit,U3: view_e774982825t_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ W ) ) )
            & ( ( nat_card @ ( lan_Product_unit @ W ) )
              = one_one_nat )
            & ! [C3: cars] :
                ( ( ( real_length @ ( len @ regular_regular @ W @ Ts2 @ C3 ) )
                  = zero_zero_real )
                | ( ( ( restrict @ W @ ( clm @ Ts2 ) @ C3 )
                    = bot_bot_nat_int )
                  & ( ( restrict @ W @ ( res @ Ts2 ) @ C3 )
                    = bot_bot_nat_int ) ) )
            & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U3 ) ) )
            & ( ( nat_card @ ( lan_Product_unit @ U3 ) )
              = one_one_nat )
            & ! [C3: cars] :
                ( ( ( real_length @ ( len @ regular_regular @ U3 @ Ts2 @ C3 ) )
                  = zero_zero_real )
                | ( ( ( restrict @ U3 @ ( clm @ Ts2 ) @ C3 )
                    = bot_bot_nat_int )
                  & ( ( restrict @ U3 @ ( res @ Ts2 ) @ C3 )
                    = bot_bot_nat_int ) ) ) ) ) ) ).

% local.hmlsl.free_dense
thf(fact_62_local_Ohmlsl_Ofree__decompose,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = bot_bot_nat_int ) ) ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va2 ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va2 ) )
            = one_one_nat )
          & ! [C4: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ Va2 @ Ts2 @ C4 ) )
                = zero_zero_real )
              | ( ( ( restrict @ Va2 @ ( clm @ Ts2 ) @ C4 )
                  = bot_bot_nat_int )
                & ( ( restrict @ Va2 @ ( res @ Ts2 ) @ C4 )
                  = bot_bot_nat_int ) ) )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U2 ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ U2 ) )
            = one_one_nat )
          & ! [C4: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ U2 @ Ts2 @ C4 ) )
                = zero_zero_real )
              | ( ( ( restrict @ U2 @ ( clm @ Ts2 ) @ C4 )
                  = bot_bot_nat_int )
                & ( ( restrict @ U2 @ ( res @ Ts2 ) @ C4 )
                  = bot_bot_nat_int ) ) ) ) ) ).

% local.hmlsl.free_decompose
thf(fact_63_local_Ohmlsl_Ofree__compose,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ Va ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = one_one_nat )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ Va @ Ts2 @ C2 ) )
                = zero_zero_real )
              | ( ( ( restrict @ Va @ ( clm @ Ts2 ) @ C2 )
                  = bot_bot_nat_int )
                & ( ( restrict @ Va @ ( res @ Ts2 ) @ C2 )
                  = bot_bot_nat_int ) ) )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = one_one_nat )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ U @ Ts2 @ C2 ) )
                = zero_zero_real )
              | ( ( ( restrict @ U @ ( clm @ Ts2 ) @ C2 )
                  = bot_bot_nat_int )
                & ( ( restrict @ U @ ( res @ Ts2 ) @ C2 )
                  = bot_bot_nat_int ) ) ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C4: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C4 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C4 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C4 )
                = bot_bot_nat_int ) ) ) ) ) ).

% local.hmlsl.free_compose
thf(fact_64_local_Ohmlsl_Owidth__free,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = bot_bot_nat_int ) ) ) )
     => ( ( nat_card @ ( lan_Product_unit @ V ) )
        = one_one_nat ) ) ).

% local.hmlsl.width_free
thf(fact_65_local_Ohmlsl_Ores__not__free,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
    ? [X4: cars] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ X4 )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ X4 )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ~ ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
                = zero_zero_real )
              | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                  = bot_bot_nat_int )
                & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                  = bot_bot_nat_int ) ) ) ) ) ).

% local.hmlsl.res_not_free
thf(fact_66_local_Ohmlsl_Ofree__no__res,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = bot_bot_nat_int ) ) ) )
     => ~ ? [X: cars] :
            ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) ) ) ).

% local.hmlsl.free_no_res
thf(fact_67_local_Ohmlsl_Ofree__no__clm,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = bot_bot_nat_int ) ) ) )
     => ~ ? [X: cars] :
            ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) ) ) ).

% local.hmlsl.free_no_clm
thf(fact_68_local_Ohmlsl_Ofree__ge__zero,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = zero_zero_real )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = bot_bot_nat_int )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = bot_bot_nat_int ) ) ) )
     => ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) ) ) ).

% local.hmlsl.free_ge_zero
thf(fact_69_local_Ohmlsl_Oclm__not__free,axiom,
    ! [Ts2: traffic,V: view_e774982825t_unit] :
    ? [X4: cars] :
      ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ X4 )
          = ( ext_Product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ X4 )
          = ( lan_Product_unit @ V ) )
        & ( ( nat_card @ ( lan_Product_unit @ V ) )
          = one_one_nat ) )
     => ~ ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
                = zero_zero_real )
              | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                  = bot_bot_nat_int )
                & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                  = bot_bot_nat_int ) ) ) ) ) ).

% local.hmlsl.clm_not_free
thf(fact_70_hmlsl__regular_Obackwards__wdc__res__stab,axiom,
    ! [Ts: traffic,D2: cars,Ts5: traffic,V2: view_e774982825t_unit,C: cars] :
      ( ( ( withdraw_claim @ Ts @ D2 @ Ts5 )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts5 @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts5 ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) ) ) ).

% hmlsl_regular.backwards_wdc_res_stab
thf(fact_71_view_Ohorizontal__chop__non__empty,axiom,
    ! [V2: view_e774982825t_unit] :
      ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
     => ? [U2: view_e774982825t_unit,W2: view_e774982825t_unit] :
          ( ( hchop @ V2 @ U2 @ W2 )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ U2 ) ) )
          & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ W2 ) ) ) ) ) ).

% view.horizontal_chop_non_empty
thf(fact_72_not__gr__zero,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr_zero
thf(fact_73_le__zero__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_zero_eq
thf(fact_74_hmlsl__regular_Obackwards__c__res__stab,axiom,
    ! [Ts: traffic,D2: cars,N: nat,Ts5: traffic,V2: view_e774982825t_unit,C: cars] :
      ( ( ( create_claim @ Ts @ D2 @ N @ Ts5 )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts5 @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts5 ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) ) ) ).

% hmlsl_regular.backwards_c_res_stab
thf(fact_75_hmlsl__regular_Obackwards__wdr__res__stab,axiom,
    ! [Ts: traffic,D2: cars,N: nat,Ts5: traffic,V2: view_e774982825t_unit,C: cars] :
      ( ( ( withdraw_reservation @ Ts @ D2 @ N @ Ts5 )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts5 @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts5 ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) ) ) ).

% hmlsl_regular.backwards_wdr_res_stab
thf(fact_76_hmlsl_Olen__sub__int,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars] : ( ord_less_eq_real_int @ ( len @ regular_regular @ V2 @ Ts @ C ) @ ( ext_Product_unit @ V2 ) ) ).

% hmlsl.len_sub_int
thf(fact_77_view_Overtical__chop__width__mon,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit,X3: nat] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 )
        & ( ( nat_card @ ( lan_Product_unit @ V33 ) )
          = X3 ) )
     => ( ord_less_eq_nat @ X3 @ ( nat_card @ ( lan_Product_unit @ V2 ) ) ) ) ).

% view.vertical_chop_width_mon
thf(fact_78_zero__reorient,axiom,
    ! [X3: real] :
      ( ( zero_zero_real = X3 )
      = ( X3 = zero_zero_real ) ) ).

% zero_reorient
thf(fact_79_zero__reorient,axiom,
    ! [X3: nat] :
      ( ( zero_zero_nat = X3 )
      = ( X3 = zero_zero_nat ) ) ).

% zero_reorient
thf(fact_80_view_Overtical__chop__singleton,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( ( vchop @ V2 @ U4 @ W3 )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ( nat_card @ ( lan_Product_unit @ U4 ) )
          = zero_zero_nat )
        | ( ( nat_card @ ( lan_Product_unit @ W3 ) )
          = zero_zero_nat ) ) ) ).

% view.vertical_chop_singleton
thf(fact_81_one__reorient,axiom,
    ! [X3: nat] :
      ( ( one_one_nat = X3 )
      = ( X3 = one_one_nat ) ) ).

% one_reorient
thf(fact_82_view_Ohorizontal__chop1,axiom,
    ! [V2: view_e774982825t_unit] :
    ? [U2: view_e774982825t_unit,X_1: view_e774982825t_unit] : ( hchop @ V2 @ U2 @ X_1 ) ).

% view.horizontal_chop1
thf(fact_83_view_Ohorizontal__chop__assoc1,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( hchop @ V22 @ V33 @ V42 ) )
     => ? [V4: view_e774982825t_unit] :
          ( ( hchop @ V2 @ V4 @ V42 )
          & ( hchop @ V4 @ V1 @ V33 ) ) ) ).

% view.horizontal_chop_assoc1
thf(fact_84_view_Ohorizontal__chop__assoc2,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( hchop @ V1 @ V33 @ V42 ) )
     => ? [V4: view_e774982825t_unit] :
          ( ( hchop @ V2 @ V33 @ V4 )
          & ( hchop @ V4 @ V42 @ V22 ) ) ) ).

% view.horizontal_chop_assoc2
thf(fact_85_view_Ohorizontal__chop__empty__left,axiom,
    ! [V: view_e774982825t_unit] :
    ? [U2: view_e774982825t_unit] : ( hchop @ V @ U2 @ V ) ).

% view.horizontal_chop_empty_left
thf(fact_86_view_Ohorizontal__chop__empty__right,axiom,
    ! [V: view_e774982825t_unit] :
    ? [X_1: view_e774982825t_unit] : ( hchop @ V @ V @ X_1 ) ).

% view.horizontal_chop_empty_right
thf(fact_87_view_Overtical__chop1,axiom,
    ! [V: view_e774982825t_unit] :
    ? [U2: view_e774982825t_unit,X_1: view_e774982825t_unit] : ( vchop @ V @ U2 @ X_1 ) ).

% view.vertical_chop1
thf(fact_88_view_Overtical__chop__assoc1,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 ) )
     => ? [V4: view_e774982825t_unit] :
          ( ( vchop @ V2 @ V4 @ V42 )
          & ( vchop @ V4 @ V1 @ V33 ) ) ) ).

% view.vertical_chop_assoc1
thf(fact_89_view_Overtical__chop__assoc2,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V1 @ V33 @ V42 ) )
     => ? [V4: view_e774982825t_unit] :
          ( ( vchop @ V2 @ V33 @ V4 )
          & ( vchop @ V4 @ V42 @ V22 ) ) ) ).

% view.vertical_chop_assoc2
thf(fact_90_view_Overtical__chop__empty__up,axiom,
    ! [V: view_e774982825t_unit] :
    ? [U2: view_e774982825t_unit] : ( vchop @ V @ U2 @ V ) ).

% view.vertical_chop_empty_up
thf(fact_91_view_Overtical__chop__empty__down,axiom,
    ! [V: view_e774982825t_unit] :
    ? [X_1: view_e774982825t_unit] : ( vchop @ V @ V @ X_1 ) ).

% view.vertical_chop_empty_down
thf(fact_92_zero__le,axiom,
    ! [X3: nat] : ( ord_less_eq_nat @ zero_zero_nat @ X3 ) ).

% zero_le
thf(fact_93_zero__less__iff__neq__zero,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
      = ( N != zero_zero_nat ) ) ).

% zero_less_iff_neq_zero
thf(fact_94_gr__implies__not__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not_zero
thf(fact_95_not__less__zero,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less_zero
thf(fact_96_gr__zeroI,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr_zeroI
thf(fact_97_view_Ohorizontal__chop__leq2,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ord_le461438217t_unit @ W3 @ V2 ) ) ).

% view.horizontal_chop_leq2
thf(fact_98_view_Ohorizontal__chop__leq1,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ord_le461438217t_unit @ U4 @ V2 ) ) ).

% view.horizontal_chop_leq1
thf(fact_99_view_Overtical__chop__leq2,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_le461438217t_unit @ W3 @ V2 ) ) ).

% view.vertical_chop_leq2
thf(fact_100_view_Overtical__chop__leq1,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_le461438217t_unit @ U4 @ V2 ) ) ).

% view.vertical_chop_leq1
thf(fact_101_view_Ohorizontal__chop__width__stable,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = ( nat_card @ ( lan_Product_unit @ U4 ) ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = ( nat_card @ ( lan_Product_unit @ W3 ) ) ) ) ) ).

% view.horizontal_chop_width_stable
thf(fact_102_view_Overtical__chop__length__stable,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ( ( real_length @ ( ext_Product_unit @ V2 ) )
          = ( real_length @ ( ext_Product_unit @ U4 ) ) )
        & ( ( real_length @ ( ext_Product_unit @ V2 ) )
          = ( real_length @ ( ext_Product_unit @ W3 ) ) ) ) ) ).

% view.vertical_chop_length_stable
thf(fact_103_view_Osomewhere__leq,axiom,
    ( ord_le461438217t_unit
    = ( ^ [V5: view_e774982825t_unit,V6: view_e774982825t_unit] :
        ? [V13: view_e774982825t_unit,V24: view_e774982825t_unit,V34: view_e774982825t_unit,Vl: view_e774982825t_unit,Vr: view_e774982825t_unit,Vu: view_e774982825t_unit,Vd: view_e774982825t_unit] :
          ( ( hchop @ V6 @ Vl @ V13 )
          & ( hchop @ V13 @ V24 @ Vr )
          & ( vchop @ V24 @ Vd @ V34 )
          & ( vchop @ V34 @ V5 @ Vu ) ) ) ) ).

% view.somewhere_leq
thf(fact_104_hmlsl_Oview__leq__len__leq,axiom,
    ! [V2: view_e774982825t_unit,V3: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( ( ord_less_eq_real_int @ ( ext_Product_unit @ V2 ) @ ( ext_Product_unit @ V3 ) )
        & ( ( own_Product_unit @ V2 )
          = ( own_Product_unit @ V3 ) )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) ) )
     => ( ord_less_eq_real_int @ ( len @ regular_regular @ V2 @ Ts @ C ) @ ( len @ regular_regular @ V3 @ Ts @ C ) ) ) ).

% hmlsl.view_leq_len_leq
thf(fact_105_restriction_Orestriction__card__somewhere__mon,axiom,
    ! [V2: view_e774982825t_unit,Vl2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,Vr2: view_e774982825t_unit,Vu2: view_e774982825t_unit,V33: view_e774982825t_unit,V3: view_e774982825t_unit,Vd2: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( ( hchop @ V2 @ Vl2 @ V1 )
        & ( hchop @ V1 @ V22 @ Vr2 )
        & ( vchop @ V22 @ Vu2 @ V33 )
        & ( vchop @ V33 @ V3 @ Vd2 )
        & ( ( nat_card @ ( restrict @ V3 @ F @ C ) )
          = one_one_nat ) )
     => ( ord_less_eq_nat @ one_one_nat @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_somewhere_mon
thf(fact_106_hmlsl__regular_Obackwards__res__act,axiom,
    ! [Ts: traffic,C: cars,Ts5: traffic,V2: view_e774982825t_unit] :
      ( ( ( create_reservation @ Ts @ C @ Ts5 )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts5 @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts5 ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
          & ( ( len @ regular_regular @ V2 @ Ts @ C )
            = ( ext_Product_unit @ V2 ) )
          & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
            = ( lan_Product_unit @ V2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
            = one_one_nat ) )
        | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
          & ( ( len @ regular_regular @ V2 @ Ts @ C )
            = ( ext_Product_unit @ V2 ) )
          & ( ( restrict @ V2 @ ( clm @ Ts ) @ C )
            = ( lan_Product_unit @ V2 ) )
          & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
            = one_one_nat ) ) ) ) ).

% hmlsl_regular.backwards_res_act
thf(fact_107_hmlsl__regular_Oreservation2,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ! [Ts3: traffic] :
          ( ( create_reservation @ Ts2 @ C @ Ts3 )
         => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts3 @ C )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts3 ) @ C )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) ) )
     => ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) )
        | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) ) ) ) ).

% hmlsl_regular.reservation2
thf(fact_108_hmlsl__regular_Oreservation1,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) )
        | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) ) )
     => ! [Ts4: traffic] :
          ( ( create_reservation @ Ts2 @ C @ Ts4 )
         => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts4 @ C )
              = ( ext_Product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts4 ) @ C )
              = ( lan_Product_unit @ V ) )
            & ( ( nat_card @ ( lan_Product_unit @ V ) )
              = one_one_nat ) ) ) ) ).

% hmlsl_regular.reservation1
thf(fact_109_hmlsl__regular_Oreservation,axiom,
    ! [C: cars,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ! [Ts6: traffic] :
            ( ( create_reservation @ Ts2 @ C @ Ts6 )
           => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts6 @ C )
                = ( ext_Product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts6 ) @ C )
                = ( lan_Product_unit @ V ) )
              & ( ( nat_card @ ( lan_Product_unit @ V ) )
                = one_one_nat ) ) ) )
      = ( ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) )
        | ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext_Product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan_Product_unit @ V ) )
          & ( ( nat_card @ ( lan_Product_unit @ V ) )
            = one_one_nat ) ) ) ) ).

% hmlsl_regular.reservation
thf(fact_110_hmlsl_Oext__eq__len__eq,axiom,
    ! [V2: view_e774982825t_unit,V3: view_e774982825t_unit,Ts: traffic,C: cars] :
      ( ( ( ( ext_Product_unit @ V2 )
          = ( ext_Product_unit @ V3 ) )
        & ( ( own_Product_unit @ V2 )
          = ( own_Product_unit @ V3 ) ) )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V3 @ Ts @ C ) ) ) ).

% hmlsl.ext_eq_len_eq
thf(fact_111_view_Ohorizontal__chop__own__trans,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( own_Product_unit @ U4 )
        = ( own_Product_unit @ W3 ) ) ) ).

% view.horizontal_chop_own_trans
thf(fact_112_view_Overtical__chop__own__trans,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ( own_Product_unit @ U4 )
        = ( own_Product_unit @ W3 ) ) ) ).

% view.vertical_chop_own_trans
thf(fact_113_restriction_Orestrict__subseteq,axiom,
    ! [V2: view_e774982825t_unit,F: cars > nat_int,C: cars] : ( ord_less_eq_nat_int @ ( restrict @ V2 @ F @ C ) @ ( F @ C ) ) ).

% restriction.restrict_subseteq
thf(fact_114_restriction_Orestrict__view,axiom,
    ! [V2: view_e774982825t_unit,F: cars > nat_int,C: cars] : ( ord_less_eq_nat_int @ ( restrict @ V2 @ F @ C ) @ ( lan_Product_unit @ V2 ) ) ).

% restriction.restrict_view
thf(fact_115_restriction_Orestrict__res,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars] : ( ord_less_eq_nat_int @ ( restrict @ V2 @ ( res @ Ts ) @ C ) @ ( res @ Ts @ C ) ) ).

% restriction.restrict_res
thf(fact_116_restriction_Orestriction__stable,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ U4 @ F @ C )
        = ( restrict @ W3 @ F @ C ) ) ) ).

% restriction.restriction_stable
thf(fact_117_restriction_Orestriction__stable1,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ V2 @ F @ C )
        = ( restrict @ U4 @ F @ C ) ) ) ).

% restriction.restriction_stable1
thf(fact_118_restriction_Orestriction__stable2,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ V2 @ F @ C )
        = ( restrict @ W3 @ F @ C ) ) ) ).

% restriction.restriction_stable2
thf(fact_119_restriction_Orestrict__clm,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars] : ( ord_less_eq_nat_int @ ( restrict @ V2 @ ( clm @ Ts ) @ C ) @ ( clm @ Ts @ C ) ) ).

% restriction.restrict_clm
thf(fact_120_restriction_Orestriction__mon2,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq_nat_int @ ( restrict @ W3 @ F @ C ) @ ( restrict @ V2 @ F @ C ) ) ) ).

% restriction.restriction_mon2
thf(fact_121_restriction_Orestriction__mon1,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq_nat_int @ ( restrict @ U4 @ F @ C ) @ ( restrict @ V2 @ F @ C ) ) ) ).

% restriction.restriction_mon1
thf(fact_122_restriction_Orestriction__eq__view__card,axiom,
    ! [V2: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( ( restrict @ V2 @ F @ C )
        = ( lan_Product_unit @ V2 ) )
     => ( ( nat_card @ ( restrict @ V2 @ F @ C ) )
        = ( nat_card @ ( lan_Product_unit @ V2 ) ) ) ) ).

% restriction.restriction_eq_view_card
thf(fact_123_restriction_Orestrict__eq__lan__subs,axiom,
    ! [V2: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( ( ( nat_card @ ( restrict @ V2 @ F @ C ) )
          = ( nat_card @ ( lan_Product_unit @ V2 ) ) )
        & ( ord_less_eq_nat_int @ ( restrict @ V2 @ F @ C ) @ ( lan_Product_unit @ V2 ) ) )
     => ( ( restrict @ V2 @ F @ C )
        = ( lan_Product_unit @ V2 ) ) ) ).

% restriction.restrict_eq_lan_subs
thf(fact_124_restriction_Orestriction__card__mon1,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq_nat @ ( nat_card @ ( restrict @ U4 @ F @ C ) ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon1
thf(fact_125_restriction_Orestriction__card__mon2,axiom,
    ! [V2: view_e774982825t_unit,U4: view_e774982825t_unit,W3: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq_nat @ ( nat_card @ ( restrict @ W3 @ F @ C ) ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon2
thf(fact_126_restriction_Orestriction__clm__leq__one,axiom,
    ! [V2: view_e774982825t_unit,Ts: traffic,C: cars] : ( ord_less_eq_nat @ ( nat_card @ ( restrict @ V2 @ ( clm @ Ts ) @ C ) ) @ one_one_nat ) ).

% restriction.restriction_clm_leq_one
thf(fact_127_restriction_Orestriction__card__mon__trans,axiom,
    ! [V2: view_e774982825t_unit,V1: view_e774982825t_unit,V22: view_e774982825t_unit,V33: view_e774982825t_unit,V42: view_e774982825t_unit,F: cars > nat_int,C: cars] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 )
        & ( ( nat_card @ ( restrict @ V33 @ F @ C ) )
          = one_one_nat ) )
     => ( ord_less_eq_nat @ one_one_nat @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon_trans
thf(fact_128_hmlsl__regular_Obackwards__res__stab,axiom,
    ! [Ts: traffic,D2: cars,Ts5: traffic,C: cars,V2: view_e774982825t_unit] :
      ( ( ( create_reservation @ Ts @ D2 @ Ts5 )
        & ( D2 != C )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts5 @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts5 ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) )
     => ( ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext_Product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan_Product_unit @ V2 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V2 ) )
          = one_one_nat ) ) ) ).

% hmlsl_regular.backwards_res_stab
thf(fact_129_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ N @ one_one_nat )
      = ( N = zero_zero_nat ) ) ).

% less_one
thf(fact_130_le0,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% le0
thf(fact_131_bot__nat__0_Oextremum,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ zero_zero_nat @ A ) ).

% bot_nat_0.extremum
thf(fact_132_card__non__empty__geq__one,axiom,
    ! [I: nat_int] :
      ( ( I != bot_bot_nat_int )
      = ( ord_less_eq_nat @ one_one_nat @ ( nat_card @ I ) ) ) ).

% card_non_empty_geq_one
thf(fact_133_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A: nat] :
      ( ( A != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ A ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_134_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_nat_zero_code
thf(fact_135_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% neq0_conv
thf(fact_136_linorder__neqE__nat,axiom,
    ! [X3: nat,Y2: nat] :
      ( ( X3 != Y2 )
     => ( ~ ( ord_less_nat @ X3 @ Y2 )
       => ( ord_less_nat @ Y2 @ X3 ) ) ) ).

% linorder_neqE_nat
thf(fact_137_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P @ N2 )
         => ? [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
              & ~ ( P @ M2 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_138_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
             => ( P @ M2 ) )
         => ( P @ N2 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_139_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_140_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less_nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_141_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_142_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_not_refl
thf(fact_143_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_144_bot__nat__0_Oextremum__strict,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ zero_zero_nat ) ).

% bot_nat_0.extremum_strict
thf(fact_145_infinite__descent0,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ zero_zero_nat )
     => ( ! [N2: nat] :
            ( ( ord_less_nat @ zero_zero_nat @ N2 )
           => ( ~ ( P @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less_nat @ M2 @ N2 )
                  & ~ ( P @ M2 ) ) ) )
       => ( P @ N ) ) ) ).

% infinite_descent0
thf(fact_146_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not0
thf(fact_147_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_zeroE
thf(fact_148_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less0
thf(fact_149_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr0
thf(fact_150_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr0I
thf(fact_151_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less_nat @ I2 @ J2 )
         => ( ord_less_nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq_nat @ I @ J )
       => ( ord_less_eq_nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_152_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( M != N )
       => ( ord_less_nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_153_Nat_Oex__has__greatest__nat,axiom,
    ! [P: nat > $o,K: nat,B: nat] :
      ( ( P @ K )
     => ( ! [Y3: nat] :
            ( ( P @ Y3 )
           => ( ord_less_eq_nat @ Y3 @ B ) )
       => ? [X4: nat] :
            ( ( P @ X4 )
            & ! [Y4: nat] :
                ( ( P @ Y4 )
               => ( ord_less_eq_nat @ Y4 @ X4 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_154_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_155_le__eq__less__or__eq,axiom,
    ( ord_less_eq_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_nat @ M3 @ N3 )
          | ( M3 = N3 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_156_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_157_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_158_nat__less__le,axiom,
    ( ord_less_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_eq_nat @ M3 @ N3 )
          & ( M3 != N3 ) ) ) ) ).

% nat_less_le
thf(fact_159_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_160_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_161_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ord_less_eq_nat @ I @ K ) ) ) ).

% le_trans
thf(fact_162_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ N @ N ) ).

% le_refl
thf(fact_163_card__subset__less,axiom,
    ! [I: nat_int,I3: nat_int] :
      ( ( ord_less_nat_int @ I @ I3 )
     => ( ord_less_nat @ ( nat_card @ I ) @ ( nat_card @ I3 ) ) ) ).

% card_subset_less
thf(fact_164_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
     => ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_165_bot__nat__0_Oextremum__unique,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
      = ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_unique
thf(fact_166_ex__least__nat__le,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ N )
     => ( ~ ( P @ zero_zero_nat )
       => ? [K2: nat] :
            ( ( ord_less_eq_nat @ K2 @ N )
            & ! [I4: nat] :
                ( ( ord_less_nat @ I4 @ K2 )
               => ~ ( P @ I4 ) )
            & ( P @ K2 ) ) ) ) ).

% ex_least_nat_le
thf(fact_167_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_0_eq
thf(fact_168_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% less_eq_nat.simps(1)
thf(fact_169_card__subset__le,axiom,
    ! [I: nat_int,I3: nat_int] :
      ( ( ord_less_eq_nat_int @ I @ I3 )
     => ( ord_less_eq_nat @ ( nat_card @ I ) @ ( nat_card @ I3 ) ) ) ).

% card_subset_le
thf(fact_170_card__empty__zero,axiom,
    ( ( nat_card @ bot_bot_nat_int )
    = zero_zero_nat ) ).

% card_empty_zero
thf(fact_171_local_Ohmlsl_Owidth__ge,axiom,
    ! [V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit] :
          ( ? [X_12: view_e774982825t_unit] : ( vchop @ V @ Va @ X_12 )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = ( plus_plus_nat @ zero_zero_nat @ one_one_nat ) ) )
     => ( ord_less_nat @ zero_zero_nat @ ( nat_card @ ( lan_Product_unit @ V ) ) ) ) ).

% local.hmlsl.width_ge
thf(fact_172_traffic_Ocreate__res__subseteq2,axiom,
    ! [Ts: traffic,C: cars,Ts5: traffic] :
      ( ( create_reservation @ Ts @ C @ Ts5 )
     => ( ord_less_eq_nat_int @ ( clm @ Ts @ C ) @ ( res @ Ts5 @ C ) ) ) ).

% traffic.create_res_subseteq2
thf(fact_173_traffic_OatMostOneClm,axiom,
    ! [Ts: traffic,C: cars] : ( ord_less_eq_nat @ ( nat_card @ ( clm @ Ts @ C ) ) @ one_one_nat ) ).

% traffic.atMostOneClm
thf(fact_174_traffic_OatLeastOneRes,axiom,
    ! [Ts: traffic,C: cars] : ( ord_less_eq_nat @ one_one_nat @ ( nat_card @ ( res @ Ts @ C ) ) ) ).

% traffic.atLeastOneRes
thf(fact_175_local_Ohmlsl_Owidth__add1,axiom,
    ! [X3: nat,Y2: nat,Ts2: traffic,V: view_e774982825t_unit] :
      ( ? [Va: view_e774982825t_unit,U: view_e774982825t_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ( nat_card @ ( lan_Product_unit @ Va ) )
            = X3 )
          & ( ( nat_card @ ( lan_Product_unit @ U ) )
            = Y2 ) )
     => ( ( nat_card @ ( lan_Product_unit @ V ) )
        = ( plus_plus_nat @ X3 @ Y2 ) ) ) ).

% local.hmlsl.width_add1
thf(fact_176_local_Ohmlsl_Owidth__add2,axiom,
    ! [X3: nat,Y2: nat,Ts2: traffic,V: view_e774982825t_unit] :
      ( ( ( nat_card @ ( lan_Product_unit @ V ) )
        = ( plus_plus_nat @ X3 @ Y2 ) )
     => ? [Va2: view_e774982825t_unit,U2: view_e774982825t_unit] :
          ( ( vchop @ V @ Va2 @ U2 )
          & ( ( nat_card @ ( lan_Product_unit @ Va2 ) )
            = X3 )
          & ( ( nat_card @ ( lan_Product_unit @ U2 ) )
            = Y2 ) ) ) ).

% local.hmlsl.width_add2
thf(fact_177_add__left__cancel,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ( plus_plus_real @ A @ B )
        = ( plus_plus_real @ A @ C ) )
      = ( B = C ) ) ).

% add_left_cancel
thf(fact_178_add__left__cancel,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ( plus_plus_nat @ A @ B )
        = ( plus_plus_nat @ A @ C ) )
      = ( B = C ) ) ).

% add_left_cancel
thf(fact_179_add__right__cancel,axiom,
    ! [B: real,A: real,C: real] :
      ( ( ( plus_plus_real @ B @ A )
        = ( plus_plus_real @ C @ A ) )
      = ( B = C ) ) ).

% add_right_cancel
thf(fact_180_add__right__cancel,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ( plus_plus_nat @ B @ A )
        = ( plus_plus_nat @ C @ A ) )
      = ( B = C ) ) ).

% add_right_cancel
thf(fact_181_add__le__cancel__left,axiom,
    ! [C: real,A: real,B: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) )
      = ( ord_less_eq_real @ A @ B ) ) ).

% add_le_cancel_left
thf(fact_182_add__le__cancel__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
      = ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_cancel_left
thf(fact_183_add__le__cancel__right,axiom,
    ! [A: real,C: real,B: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) )
      = ( ord_less_eq_real @ A @ B ) ) ).

% add_le_cancel_right
thf(fact_184_add__le__cancel__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
      = ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_cancel_right
thf(fact_185_add_Oleft__neutral,axiom,
    ! [A: real] :
      ( ( plus_plus_real @ zero_zero_real @ A )
      = A ) ).

% add.left_neutral
thf(fact_186_add_Oleft__neutral,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A )
      = A ) ).

% add.left_neutral
thf(fact_187_add_Oright__neutral,axiom,
    ! [A: real] :
      ( ( plus_plus_real @ A @ zero_zero_real )
      = A ) ).

% add.right_neutral
thf(fact_188_add_Oright__neutral,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ A @ zero_zero_nat )
      = A ) ).

% add.right_neutral
thf(fact_189_double__zero,axiom,
    ! [A: real] :
      ( ( ( plus_plus_real @ A @ A )
        = zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% double_zero
thf(fact_190_double__zero__sym,axiom,
    ! [A: real] :
      ( ( zero_zero_real
        = ( plus_plus_real @ A @ A ) )
      = ( A = zero_zero_real ) ) ).

% double_zero_sym
thf(fact_191_add__cancel__left__left,axiom,
    ! [B: real,A: real] :
      ( ( ( plus_plus_real @ B @ A )
        = A )
      = ( B = zero_zero_real ) ) ).

% add_cancel_left_left
thf(fact_192_add__cancel__left__left,axiom,
    ! [B: nat,A: nat] :
      ( ( ( plus_plus_nat @ B @ A )
        = A )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_left_left
thf(fact_193_add__cancel__left__right,axiom,
    ! [A: real,B: real] :
      ( ( ( plus_plus_real @ A @ B )
        = A )
      = ( B = zero_zero_real ) ) ).

% add_cancel_left_right
thf(fact_194_add__cancel__left__right,axiom,
    ! [A: nat,B: nat] :
      ( ( ( plus_plus_nat @ A @ B )
        = A )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_left_right
thf(fact_195_add__cancel__right__left,axiom,
    ! [A: real,B: real] :
      ( ( A
        = ( plus_plus_real @ B @ A ) )
      = ( B = zero_zero_real ) ) ).

% add_cancel_right_left
thf(fact_196_add__cancel__right__left,axiom,
    ! [A: nat,B: nat] :
      ( ( A
        = ( plus_plus_nat @ B @ A ) )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_right_left
thf(fact_197_add__cancel__right__right,axiom,
    ! [A: real,B: real] :
      ( ( A
        = ( plus_plus_real @ A @ B ) )
      = ( B = zero_zero_real ) ) ).

% add_cancel_right_right
thf(fact_198_add__cancel__right__right,axiom,
    ! [A: nat,B: nat] :
      ( ( A
        = ( plus_plus_nat @ A @ B ) )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_right_right
thf(fact_199_add__eq__0__iff__both__eq__0,axiom,
    ! [X3: nat,Y2: nat] :
      ( ( ( plus_plus_nat @ X3 @ Y2 )
        = zero_zero_nat )
      = ( ( X3 = zero_zero_nat )
        & ( Y2 = zero_zero_nat ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_200_zero__eq__add__iff__both__eq__0,axiom,
    ! [X3: nat,Y2: nat] :
      ( ( zero_zero_nat
        = ( plus_plus_nat @ X3 @ Y2 ) )
      = ( ( X3 = zero_zero_nat )
        & ( Y2 = zero_zero_nat ) ) ) ).

% zero_eq_add_iff_both_eq_0
thf(fact_201_add__less__cancel__left,axiom,
    ! [C: real,A: real,B: real] :
      ( ( ord_less_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) )
      = ( ord_less_real @ A @ B ) ) ).

% add_less_cancel_left
thf(fact_202_add__less__cancel__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
      = ( ord_less_nat @ A @ B ) ) ).

% add_less_cancel_left
thf(fact_203_add__less__cancel__right,axiom,
    ! [A: real,C: real,B: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) )
      = ( ord_less_real @ A @ B ) ) ).

% add_less_cancel_right
thf(fact_204_add__less__cancel__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
      = ( ord_less_nat @ A @ B ) ) ).

% add_less_cancel_right
thf(fact_205_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = zero_zero_nat )
      = ( ( M = zero_zero_nat )
        & ( N = zero_zero_nat ) ) ) ).

% add_is_0
thf(fact_206_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus_nat @ M @ zero_zero_nat )
      = M ) ).

% Nat.add_0_right
thf(fact_207_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
      = ( ord_less_nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_208_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_209_add__le__same__cancel1,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ B @ A ) @ B )
      = ( ord_less_eq_real @ A @ zero_zero_real ) ) ).

% add_le_same_cancel1
thf(fact_210_add__le__same__cancel1,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ B @ A ) @ B )
      = ( ord_less_eq_nat @ A @ zero_zero_nat ) ) ).

% add_le_same_cancel1
thf(fact_211_add__le__same__cancel2,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A @ B ) @ B )
      = ( ord_less_eq_real @ A @ zero_zero_real ) ) ).

% add_le_same_cancel2
thf(fact_212_add__le__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ B ) @ B )
      = ( ord_less_eq_nat @ A @ zero_zero_nat ) ) ).

% add_le_same_cancel2
thf(fact_213_le__add__same__cancel1,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_eq_real @ A @ ( plus_plus_real @ A @ B ) )
      = ( ord_less_eq_real @ zero_zero_real @ B ) ) ).

% le_add_same_cancel1
thf(fact_214_le__add__same__cancel1,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ ( plus_plus_nat @ A @ B ) )
      = ( ord_less_eq_nat @ zero_zero_nat @ B ) ) ).

% le_add_same_cancel1
thf(fact_215_le__add__same__cancel2,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_eq_real @ A @ ( plus_plus_real @ B @ A ) )
      = ( ord_less_eq_real @ zero_zero_real @ B ) ) ).

% le_add_same_cancel2
thf(fact_216_le__add__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ ( plus_plus_nat @ B @ A ) )
      = ( ord_less_eq_nat @ zero_zero_nat @ B ) ) ).

% le_add_same_cancel2
thf(fact_217_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A @ A ) @ zero_zero_real )
      = ( ord_less_eq_real @ A @ zero_zero_real ) ) ).

% double_add_le_zero_iff_single_add_le_zero
thf(fact_218_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ ( plus_plus_real @ A @ A ) )
      = ( ord_less_eq_real @ zero_zero_real @ A ) ) ).

% zero_le_double_add_iff_zero_le_single_add
thf(fact_219_add__less__same__cancel1,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_real @ ( plus_plus_real @ B @ A ) @ B )
      = ( ord_less_real @ A @ zero_zero_real ) ) ).

% add_less_same_cancel1
thf(fact_220_add__less__same__cancel1,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ B @ A ) @ B )
      = ( ord_less_nat @ A @ zero_zero_nat ) ) ).

% add_less_same_cancel1
thf(fact_221_add__less__same__cancel2,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A @ B ) @ B )
      = ( ord_less_real @ A @ zero_zero_real ) ) ).

% add_less_same_cancel2
thf(fact_222_add__less__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ B ) @ B )
      = ( ord_less_nat @ A @ zero_zero_nat ) ) ).

% add_less_same_cancel2
thf(fact_223_less__add__same__cancel1,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ ( plus_plus_real @ A @ B ) )
      = ( ord_less_real @ zero_zero_real @ B ) ) ).

% less_add_same_cancel1
thf(fact_224_less__add__same__cancel1,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ ( plus_plus_nat @ A @ B ) )
      = ( ord_less_nat @ zero_zero_nat @ B ) ) ).

% less_add_same_cancel1
thf(fact_225_less__add__same__cancel2,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ ( plus_plus_real @ B @ A ) )
      = ( ord_less_real @ zero_zero_real @ B ) ) ).

% less_add_same_cancel2
thf(fact_226_less__add__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ ( plus_plus_nat @ B @ A ) )
      = ( ord_less_nat @ zero_zero_nat @ B ) ) ).

% less_add_same_cancel2
thf(fact_227_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A @ A ) @ zero_zero_real )
      = ( ord_less_real @ A @ zero_zero_real ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_228_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: real] :
      ( ( ord_less_real @ zero_zero_real @ ( plus_plus_real @ A @ A ) )
      = ( ord_less_real @ zero_zero_real @ A ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_229_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ M @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ M )
        | ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% add_gr_0
thf(fact_230_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq_nat @ M @ N )
         => ~ ( ord_less_eq_nat @ K @ N ) ) ) ).

% add_leE
thf(fact_231_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq_nat @ N @ ( plus_plus_nat @ N @ M ) ) ).

% le_add1
thf(fact_232_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq_nat @ N @ ( plus_plus_nat @ M @ N ) ) ).

% le_add2
thf(fact_233_add__leD1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% add_leD1
thf(fact_234_add__leD2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ M @ K ) @ N )
     => ( ord_less_eq_nat @ K @ N ) ) ).

% add_leD2
thf(fact_235_le__Suc__ex,axiom,
    ! [K: nat,L: nat] :
      ( ( ord_less_eq_nat @ K @ L )
     => ? [N2: nat] :
          ( L
          = ( plus_plus_nat @ K @ N2 ) ) ) ).

% le_Suc_ex
thf(fact_236_add__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ( ord_less_eq_nat @ K @ L )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ) ).

% add_le_mono
thf(fact_237_add__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_238_trans__le__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ I @ ( plus_plus_nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_239_trans__le__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq_nat @ I @ J )
     => ( ord_less_eq_nat @ I @ ( plus_plus_nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_240_nat__le__iff__add,axiom,
    ( ord_less_eq_nat
    = ( ^ [M3: nat,N3: nat] :
        ? [K3: nat] :
          ( N3
          = ( plus_plus_nat @ M3 @ K3 ) ) ) ) ).

% nat_le_iff_add
thf(fact_241_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_242_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = M )
     => ( N = zero_zero_nat ) ) ).

% add_eq_self_zero
thf(fact_243_add__le__imp__le__right,axiom,
    ! [A: real,C: real,B: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) )
     => ( ord_less_eq_real @ A @ B ) ) ).

% add_le_imp_le_right
thf(fact_244_add__le__imp__le__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
     => ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_imp_le_right
thf(fact_245_add__le__imp__le__left,axiom,
    ! [C: real,A: real,B: real] :
      ( ( ord_less_eq_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) )
     => ( ord_less_eq_real @ A @ B ) ) ).

% add_le_imp_le_left
thf(fact_246_add__le__imp__le__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
     => ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_imp_le_left
thf(fact_247_le__iff__add,axiom,
    ( ord_less_eq_nat
    = ( ^ [A2: nat,B2: nat] :
        ? [C3: nat] :
          ( B2
          = ( plus_plus_nat @ A2 @ C3 ) ) ) ) ).

% le_iff_add
thf(fact_248_add__right__mono,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ord_less_eq_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) ) ) ).

% add_right_mono
thf(fact_249_add__right__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) ) ) ).

% add_right_mono
thf(fact_250_less__eqE,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ~ ! [C2: nat] :
            ( B
           != ( plus_plus_nat @ A @ C2 ) ) ) ).

% less_eqE
thf(fact_251_add__left__mono,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ord_less_eq_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) ) ) ).

% add_left_mono
thf(fact_252_add__left__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) ) ) ).

% add_left_mono
thf(fact_253_add__mono,axiom,
    ! [A: real,B: real,C: real,D2: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_real @ C @ D2 )
       => ( ord_less_eq_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ D2 ) ) ) ) ).

% add_mono
thf(fact_254_add__mono,axiom,
    ! [A: nat,B: nat,C: nat,D2: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ C @ D2 )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ D2 ) ) ) ) ).

% add_mono
thf(fact_255_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( ord_less_eq_real @ I @ J )
        & ( ord_less_eq_real @ K @ L ) )
     => ( ord_less_eq_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_256_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_eq_nat @ I @ J )
        & ( ord_less_eq_nat @ K @ L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_257_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( I = J )
        & ( ord_less_eq_real @ K @ L ) )
     => ( ord_less_eq_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_258_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( I = J )
        & ( ord_less_eq_nat @ K @ L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_259_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( ord_less_eq_real @ I @ J )
        & ( K = L ) )
     => ( ord_less_eq_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_260_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_eq_nat @ I @ J )
        & ( K = L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_261_add__less__imp__less__right,axiom,
    ! [A: real,C: real,B: real] :
      ( ( ord_less_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) )
     => ( ord_less_real @ A @ B ) ) ).

% add_less_imp_less_right
thf(fact_262_add__less__imp__less__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
     => ( ord_less_nat @ A @ B ) ) ).

% add_less_imp_less_right
thf(fact_263_add__less__imp__less__left,axiom,
    ! [C: real,A: real,B: real] :
      ( ( ord_less_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) )
     => ( ord_less_real @ A @ B ) ) ).

% add_less_imp_less_left
thf(fact_264_add__less__imp__less__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
     => ( ord_less_nat @ A @ B ) ) ).

% add_less_imp_less_left
thf(fact_265_add__strict__right__mono,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ord_less_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ C ) ) ) ).

% add_strict_right_mono
thf(fact_266_add__strict__right__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) ) ) ).

% add_strict_right_mono
thf(fact_267_add__strict__left__mono,axiom,
    ! [A: real,B: real,C: real] :
      ( ( ord_less_real @ A @ B )
     => ( ord_less_real @ ( plus_plus_real @ C @ A ) @ ( plus_plus_real @ C @ B ) ) ) ).

% add_strict_left_mono
thf(fact_268_add__strict__left__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) ) ) ).

% add_strict_left_mono
thf(fact_269_add__strict__mono,axiom,
    ! [A: real,B: real,C: real,D2: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ C @ D2 )
       => ( ord_less_real @ ( plus_plus_real @ A @ C ) @ ( plus_plus_real @ B @ D2 ) ) ) ) ).

% add_strict_mono
thf(fact_270_add__strict__mono,axiom,
    ! [A: nat,B: nat,C: nat,D2: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ C @ D2 )
       => ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ D2 ) ) ) ) ).

% add_strict_mono
thf(fact_271_add__mono__thms__linordered__field_I1_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( ord_less_real @ I @ J )
        & ( K = L ) )
     => ( ord_less_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_272_add__mono__thms__linordered__field_I1_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_nat @ I @ J )
        & ( K = L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_273_add__mono__thms__linordered__field_I2_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( I = J )
        & ( ord_less_real @ K @ L ) )
     => ( ord_less_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_274_add__mono__thms__linordered__field_I2_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( I = J )
        & ( ord_less_nat @ K @ L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_275_add__mono__thms__linordered__field_I5_J,axiom,
    ! [I: real,J: real,K: real,L: real] :
      ( ( ( ord_less_real @ I @ J )
        & ( ord_less_real @ K @ L ) )
     => ( ord_less_real @ ( plus_plus_real @ I @ K ) @ ( plus_plus_real @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_276_add__mono__thms__linordered__field_I5_J,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_nat @ I @ J )
        & ( ord_less_nat @ K @ L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_277_less__add__eq__less,axiom,
    ! [K: nat,L: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ K @ L )
     => ( ( ( plus_plus_nat @ M @ L )
          = ( plus_plus_nat @ K @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% less_add_eq_less
thf(fact_278_trans__less__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ I @ ( plus_plus_nat @ M @ J ) ) ) ).

% trans_less_add2
thf(fact_279_trans__less__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ I @ ( plus_plus_nat @ J @ M ) ) ) ).

% trans_less_add1
thf(fact_280_add__less__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_nat @ I @ J )
     => ( ord_less_nat @ ( plus_plus_nat @ I @ K ) @ ( plus_plus_nat @ J @ K ) ) ) ).

% add_less_mono1
thf(fact_281_not__add__less2,axiom,
    ! [J: nat,I: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ J @ I ) @ I ) ).

% not_add_less2
thf(fact_282_not__add__less1,axiom,
    ! [I: nat,J: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ I @ J ) @ I ) ).

% not_add_less1

% Conjectures (2)
thf(conj_0,hypothesis,
    ! [V7: view_e774982825t_unit] :
      ( ( ( ord_le461438217t_unit @ V7 @ ( move @ ts3 @ ts @ v ) )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V7 ) ) )
        & ( ( len @ regular_regular @ V7 @ ts @ c )
          = ( ext_Product_unit @ V7 ) )
        & ( ( restrict @ V7 @ ( res @ ts ) @ c )
          = ( lan_Product_unit @ V7 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V7 ) )
          = one_one_nat )
        & ( ord_less_real @ zero_zero_real @ ( real_length @ ( ext_Product_unit @ V7 ) ) )
        & ( ( len @ regular_regular @ V7 @ ts @ e )
          = ( ext_Product_unit @ V7 ) )
        & ( ( restrict @ V7 @ ( res @ ts ) @ e )
          = ( lan_Product_unit @ V7 ) )
        & ( ( nat_card @ ( lan_Product_unit @ V7 ) )
          = one_one_nat ) )
     => thesis ) ).

thf(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
